//+------------------------------------------------------------------+
//|                     Indicator:           Hull moving average.mq4 |
//|                       Version:                             0.002 |
//|                     Copyright:              Rabbit Traders Group |
//|                        E-mail:       witchazel@kungfurabbits.com |
//|        Modified by Cobraforex for THV System, www.cobraforex.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, Rabbit Traders Group"
#property link      "www.artattica.net"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Yellow
#property indicator_width1 3
#property indicator_color2 Green
#property indicator_width2 3
#property indicator_color3 FireBrick
#property indicator_width3 3

extern int     xPeriod=55; 
extern double  xSlope = 2.0;

double HMA[],up[],dn[];

int init()  {
   
SetIndexStyle(0,DRAW_LINE);
SetIndexBuffer(0,HMA);
SetIndexLabel(0,"HMA " + xPeriod + " , " + xSlope) ;
 
SetIndexStyle(1,DRAW_LINE);
SetIndexBuffer(1,up);

SetIndexStyle(2,DRAW_LINE);
SetIndexBuffer(2,dn);

return(0);

}

int deinit()  {return(0); }

int start()  {

double sqrt = MathRound ( MathSqrt( xPeriod ) );

for(int i=Bars;i>=0;i--) {   
   double sum = 0;
   int wma_sum = 0;
   for(int j=0; j < sqrt; j++) {      
      double val = 2*iMA(NULL, 0, MathRound(xPeriod/2), 0, MODE_LWMA, PRICE_MEDIAN, i+j)- iMA(NULL, 0, xPeriod, 0, MODE_LWMA, PRICE_MEDIAN, i+j); 
      sum = sum + val*(sqrt-j);
      wma_sum = wma_sum + (sqrt-j);   
   } 
   HMA[i] = sum/wma_sum;
  
   if(HMA[i]>HMA[i+1]+xSlope*Point) up[i]=HMA[i];
   if(HMA[i]<HMA[i+1]-xSlope*Point) dn[i]=HMA[i];
}


return(0);  
 
}